# 解決python2和python3判定

# Python 2 和 Python 3 版本判定与兼容性处理

　　在开发跨版本兼容的 Python 脚本时，准确判断当前运行的是 Python 2 还是 Python 3 至关重要。以下是推荐的、清晰且健壮的实现方式：

## 推荐方法：使用 `sys.version_info`

　　通过检查 `sys.version_info` 的主版本号（major）来区分 Python 版本，是最可靠的方式：

```python
import sys

if sys.version_info.major == 2:
    # Python 2 环境
    from urllib import urlencode, quote
    from urlparse import urlparse
    import urllib2 as request
else:
    # Python 3 环境
    from urllib.parse import urlencode, quote, urlparse
    import urllib.request as request
```

### 说明：

- **​`sys.version_info`​**：这是一个元组，包含 `(major, minor, micro, releaselevel, serial)` 信息。
- **​`major`​**：主版本号，Python 2 为 2，Python 3 为 3。
- 此方法适用于所有 Python 2.x 和 Python 3.x 版本，无需额外依赖。

## 更高级的兼容方案（推荐用于复杂项目）

　　若需更优雅地支持多版本，可结合 `six` 库（第三方库，广泛用于 Python 2/3 兼容）：

```bash
pip install six
```

```python
import six

if six.PY2:
    # Python 2 专用逻辑
    from urllib import urlencode, quote
    from urlparse import urlparse
    import urllib2 as request
else:
    # Python 3 专用逻辑
    from urllib.parse import urlencode, quote, urlparse
    import urllib.request as request
```

> **提示**：`six` 是 Python 官方推荐的兼容性工具包，能显著简化跨版本代码编写。

## 注意事项

1. 不要使用 `sys.version` 字符串判断（易受环境影响）
2. 避免直接写 `if sys.version.startswith('2'):`（不严谨）
3. 对于新项目，建议优先使用 `six` 或 `future` 库统一管理兼容性

　　此方案已验证适用于 Python 2.7.x 和 Python 3.5+ 所有主流版本。
