# 多个异常判断

# 多个异常判断

　　在编程过程中，处理异常是确保程序健壮性和用户体验的重要环节。当代码中可能产生多种错误时，应通过结构化的异常处理机制来捕获并响应不同类型的异常，从而避免程序因未预期的错误而崩溃。

## 异常处理的基本原则

1. **明确异常类型**：针对不同的异常情况（如输入类型错误、除零错误等）分别进行处理，提升代码可读性和调试效率。
2. **优先匹配具体异常**：先捕获具体的异常类（如 `TypeError`、`ZeroDivisionError`），再用通用异常（如 `Exception`）兜底，防止遗漏关键错误。
3. **提供清晰的提示信息**：向用户输出友好且准确的错误描述，帮助快速定位问题。

## 示例代码（优化版）

```python
try:
    # 接收用户输入并尝试计算表达式
    result = eval(input("请输入一个数学表达式: "))
    print(f"计算结果为: {result}")
except TypeError:
    print("错误：传入的参数不全为数字，请检查输入内容。")
except ZeroDivisionError:
    print("错误：除数不能为零，请重新输入。")
except Exception as e:
    print(f"发生未知错误：{e}，请检查输入格式或联系技术支持。")
```

### 说明：

- 使用 `eval()` 函数执行用户输入的表达式，但需注意其潜在安全风险（如恶意代码注入）。建议仅在受信任环境中使用。
- 每种异常都有明确的反馈信息，便于用户理解并修正操作。
- 最后一个通用异常块用于捕获其他未预见的问题，增强程序容错能力。

> ⚠️ 注意：若需处理更复杂的场景（如文件读写、网络请求等），应结合具体业务逻辑扩展异常处理策略。
