# 基本异常判断

# 基本异常判断

　　在编程中，异常处理是确保程序健壮性和稳定性的关键机制。Python 提供了 `try...except...finally` 结构来捕获和处理运行时错误（即异常），从而避免程序因未处理的错误而崩溃。

## 异常处理的基本语法结构

```python
try:
    # 可能引发异常的代码块
    print("123")
    raise NetworkError("Bad hostname")  # 模拟一个自定义异常
except NetworkError as e:
    # 处理特定类型的异常（如 NetworkError）
    print(f"网络异常: {e}")
except Exception as e:
    # 捕获所有其他未明确处理的异常
    print(f"发生未知异常: {e}")
finally:
    # 无论是否有异常都会执行的清理代码
    print("扫尾执行")
```

### 说明：

- **​`try`​**​ ** 块**：包含可能抛出异常的代码。
- **​`except`​**​ ** 块**：
  - 可以指定具体的异常类型（如 `NetworkError`）进行精准捕获；
  - 若不指定异常类型，则默认捕获所有异常（推荐使用 `Exception` 类型以避免遗漏）；
  - 多个 `except` 块按顺序匹配，第一个匹配成功的会被执行。
- **​`finally`​**​ ** 块**：无论是否发生异常，该代码块都会被执行，常用于资源释放、日志记录等收尾操作。

## 最佳实践建议

1. **避免空的 **​**​`except`​**​ ** 子句**
    使用 `except Exception as e:` 而不是空的 `except:`，防止忽略重要异常或隐藏潜在问题。
2. **优先捕获具体异常**
    不要直接用通用异常处理替代具体异常处理，这有助于定位问题并提供更清晰的错误信息。
3. **合理使用 **​**​`finally`​**
    用于关闭文件、释放锁、清理临时资源等必须执行的操作，保证程序状态一致性。
4. **自定义异常类**
    如示例中的 `NetworkError`，可继承内置异常类（如 `Exception` 或 `RuntimeError`）来自定义业务相关的异常类型，提升代码可读性和维护性。

> ✅ 示例：通过上述结构可以优雅地处理网络请求失败、文件读取异常等常见场景，同时保持程序逻辑清晰、易于调试与扩展。
