import requests
import json
import sys
import logging
import re
import os


class ApiTask:
    def __init__(
            self,
            logid,
    ):
        """
        初始化Task对象
        参数:
        返回:
            无
        """
        self.__logid = logid
        self.api_base_url = os.getenv("API_BASE_URL", 'http://www.xxxxx.com')
        self.access_token = 'XXXX'
        self.refresh_token = os.getenv("API_REFRESH", 'xxxxx')

    def chat_ai(self, request_data: dict):
        """
        请求AI对话测试
        """
        url = f"{self.api_base_url}/api/aichat_api"
        headers = {
            "Content-Type": "application/json",
            "Authorization": f"Bearer {self.access_token}",
        }
        if isinstance(request_data, dict):
            payload = request_data
        else:
            payload = json.dumps(request_data)
        # print(payload)
        response = requests.post(url, headers=headers, json=payload, stream=True)
        # json_data = json.loads(response.text)
        # print(json_data)
        if response.status_code != 200:
            print(f"请求失败，状态码: {response.status_code}")
            print(f"响应内容: {response.text}")
            return None
        # return response
        answers = []  # 创建一个空列表来存储 answer
        for line in response.iter_lines(decode_unicode=True):
            # 使用字符串分割提取 JSON 部分的数据
            # print(line)
            if "answer" in line:
                json_part = line.split(":", 1)[1]  # 分割字符串，并取冒号后面的部分
                # 去除可能存在的开头和结尾的空格以及引号
                json_part = json_part.strip()
                # 使用 json.loads() 解析 JSON 数据
                ret_data = json.loads(json_part)
                if "answer" in ret_data:
                    # print(f'\033[91m{ret_data["answer"]}\033[0m', end="", flush=True)
                    # print(f'\033[34m{ret_data["answer"]}\033[0m', end="", flush=True)
                    answers.append(ret_data["answer"])

        return "".join(answers)  # 返回所有 answer

    def extract_json_blocks(self, text):
        """
        使用正则表达式提取JSON块
        :param text: 包含JSON的文本
        :return: 提取的JSON字符串或None
        """
        # 移除markdown代码块标记
        text = re.sub(r'```json\s*', '', text)
        text = re.sub(r'```\s*', '', text)

        # 使用括号计数器确保完整的最外层JSON
        json_start = text.find('{')
        if json_start == -1:
            return None

        bracket_count = 0
        json_end = json_start
        in_string = False
        escape_next = False

        for i in range(json_start, len(text)):
            char = text[i]

            if escape_next:
                escape_next = False
                continue

            if char == '\\' and in_string:
                escape_next = True
                continue

            if char == '"' and not escape_next:
                in_string = not in_string
                continue

            if not in_string:
                if char == '{':
                    bracket_count += 1
                elif char == '}':
                    bracket_count -= 1
                    if bracket_count == 0:
                        json_end = i + 1
                        break

        if bracket_count == 0:
            json_str = text[json_start:json_end]
            # 验证提取的字符串是否为有效JSON
            try:
                json.loads(json_str)
                return json_str
            except json.JSONDecodeError:
                return None

        return None


if __name__ == "__main__":
    api_task = ApiTask("123456")
    data = {
        "query": "如何解决孩子不爱洗澡？回答先称呼我的名字",
        "agent": "auto",
        "bot": "通用智能体",
        "prompt": "默认通用",
        "stream": True,
        "user_data": {
            "uid": "568233531113",
            "name": "李海斌",
            "age": "32",
            "sex": "男",
        },
        "node_data": {"demo": "100"},
        "node_tag": ["完成初始对话", "完成产品介绍"],
        "user_tag": ["高学历人士", "已成婚"],
        "history": [
            {"role": "user", "content": "你好"},
            {"role": "assistant", "content": "有什么可以帮助你的？"},
        ]
    }
    api_task.chat_ai(data)
