# AI批量搜索修改工具

一个智能的批量文件处理工具，支持搜索指定目录下的文档文件，并使用AI接口对文件内容进行优化处理。

## 功能特性

### 🔍 智能文件搜索
- 支持多种文件格式：`.md`、`.txt`、`.rst` 等
- 支持通配符模式的文件/目录忽略规则
- 递归搜索目录结构，自动排除不必要的系统目录

### 🚀 多线程并发处理
- 支持最多3个线程同时处理文件
- 线程安全的文件处理机制
- 实时显示处理进度和状态

### 🤖 AI智能优化
- 集成AI接口对文档内容进行重写和优化
- 自动去除过时信息和冗余内容
- 保持文档的原始结构和格式

### 💾 数据安全保护
- 可选的自动备份功能
- 失败回滚机制
- 详细的操作日志记录

## 项目结构

```
AI批量搜索修改/
├── main.py          # 主程序入口，包含文件搜索和多线程处理逻辑
├── chat_api.py      # AI接口封装，处理与AI服务的通信
├── test_ignore.py   # 测试文件
└── README.md        # 项目说明文档
```

## 核心模块说明

### main.py
主程序模块，包含以下核心功能：

- **配置管理**：通过 `CONFIG` 字典集中管理所有配置项
- **文件搜索**：`find_files_by_extensions()` 函数实现智能文件搜索
- **多线程处理**：`process_files_with_threading()` 管理并发任务
- **单文件处理**：`process_single_file()` 处理单个文件的完整流程

### chat_api.py
AI接口模块，提供：

- **API通信**：`ApiTask` 类封装AI服务接口
- **流式响应处理**：支持实时获取AI返回结果
- **JSON解析**：智能提取和解析AI返回的结构化数据

## 配置说明

### 主要配置项

```python
CONFIG = {
    "ENABLE_BACKUP": False,     # 是否备份原文件
    "MAX_WORKERS": 3,           # 最大并发线程数
    "FILE_EXTENSIONS": [".md", ".txt", ".rst"],  # 支持的文件格式
    "IGNORE_FILES": [...],      # 忽略的文件模式
    "IGNORE_DIRS": [...]        # 忽略的目录模式
}
```

### 配置项详解

#### ENABLE_BACKUP (备份控制)
- `True`: 处理前创建 `.backup` 备份文件
- `False`: 直接覆盖原文件，不创建备份
- **建议**: 首次使用时设置为 `True`

#### MAX_WORKERS (并发控制)
- 默认值: `3`
- 范围: 1-5 个线程
- **建议**: 根据系统性能和API限制调整

#### FILE_EXTENSIONS (文件类型)
- 支持的格式: `.md` (Markdown)、`.txt` (纯文本)、`.rst` (reStructuredText)
- 可扩展: 添加 `.doc`、`.html` 等格式
- **注意**: 必须包含点号，如 `".md"` 而不是 `"md"`

#### IGNORE_FILES (忽略文件)
支持通配符模式：
- 精确匹配: `"README.md"`
- 前缀匹配: `"LICENSE*"`
- 后缀匹配: `"*.backup"`

#### IGNORE_DIRS (忽略目录)
常用忽略目录：
- 版本控制: `.git`、`.svn`
- IDE目录: `.vscode`、`.idea`
- 构建目录: `build`、`dist`、`node_modules`

## 使用方法

### 环境准备

1. **Python环境**: 确保安装 Python 3.6+
2. **依赖库**: 安装必要的依赖包
   ```bash
   pip install requests
   ```

3. **API配置**: 在 `chat_api.py` 中配置AI服务接口
   ```python
   self.api_base_url = "YOUR_API_URL"
   self.access_token = "YOUR_ACCESS_TOKEN"
   ```

### 运行程序

1. **进入项目目录**
   ```bash
   cd d:\Git-Space\私人GIT项目\AI批量搜索修改
   ```

2. **执行主程序**
   ```bash
   python main.py
   ```

3. **查看处理结果**
   程序会显示详细的处理进度和统计信息

### 使用示例

```bash
# 启动程序
python main.py

# 输出示例
正在搜索目录: d:\Git-Space\私人GIT项目\AI批量搜索修改
搜索文件后缀: ['.md', '.txt', '.rst']
忽略文件模式: ['README.md', 'LICENSE*', ...]
忽略目录模式: ['.git', '.vscode', ...]

共找到 5 个文件:
==================================================
文件类型统计:
  .md: 3 个文件
  .txt: 2 个文件

开始多线程处理 5 个文件，最大并发数: 3，备份模式: 禁用
================================================================================
✓ [1/5] 处理成功 (原:1234字符 -> 新:1567字符) [内容**已更改**] [无备份]
    文件: ./docs/guide.md
✓ [2/5] 处理成功 (原:856字符 -> 新:923字符) [内容**已更改**] [无备份]
    文件: ./notes/todo.txt
...
```

## 功能特色

### 🔍 智能搜索功能
- **多格式支持**: 同时处理 Markdown、文本、reStructuredText 等格式
- **通配符过滤**: 灵活的文件和目录过滤规则
- **统计信息**: 提供详细的文件分布和大小统计

### ⚡ 高效并发处理
- **线程池管理**: 使用 `ThreadPoolExecutor` 实现高效的并发处理
- **进度监控**: 实时显示处理进度和状态
- **异常处理**: 完善的错误处理和恢复机制

### 🛡️ 数据安全保障
- **备份机制**: 可选的文件备份功能
- **失败回滚**: 处理失败时自动清理临时文件
- **内容验证**: 处理后验证文件完整性

### 📊 详细日志记录
- **处理状态**: 显示每个文件的处理结果
- **性能统计**: 提供处理时间和效率统计
- **错误报告**: 详细的错误信息和解决建议

## 工作流程

```mermaid
graph TB
    A[启动程序] --> B[读取配置]
    B --> C[搜索目标文件]
    C --> D[过滤忽略文件]
    D --> E[显示文件列表]
    E --> F[创建线程池]
    F --> G[并发处理文件]
    
    G --> H[读取文件内容]
    H --> I{是否需要备份?}
    I -->|是| J[创建备份文件]
    I -->|否| K[直接处理]
    J --> K
    
    K --> L[调用AI接口]
    L --> M[接收AI响应]
    M --> N[写入优化内容]
    N --> O[验证处理结果]
    O --> P[更新统计信息]
    
    P --> Q{还有文件?}
    Q -->|是| G
    Q -->|否| R[显示最终统计]
    R --> S[程序结束]
```

## 注意事项

### ⚠️ 重要提示
1. **首次使用**: 建议启用备份模式 (`ENABLE_BACKUP=True`)
2. **API限制**: 注意AI接口的调用频率限制
3. **文件权限**: 确保程序对目标文件有读写权限
4. **网络连接**: 需要稳定的网络连接访问AI服务

### 🔧 性能优化
1. **线程数量**: 根据系统性能调整 `MAX_WORKERS`
2. **文件过滤**: 合理配置忽略规则，避免处理不必要的文件
3. **批量大小**: 对于大量文件，考虑分批处理

### 🐛 常见问题
1. **API认证失败**: 检查 `access_token` 是否有效
2. **文件编码错误**: 确保文件使用 UTF-8 编码
3. **权限被拒绝**: 以管理员权限运行程序

## 更新日志

### v1.0.0 (当前版本)
- ✅ 实现基础的文件搜索和AI处理功能
- ✅ 支持多线程并发处理
- ✅ 添加文件备份和安全机制
- ✅ 完善的配置管理和日志记录

### 计划功能
- 🔄 支持更多文件格式
- 🔄 添加处理结果的质量评估
- 🔄 实现增量处理模式
- 🔄 添加Web界面管理

## 许可证

本项目仅供学习和个人使用。

## 联系方式

如有问题或建议，请通过以下方式联系：
- 📧 Email: [您的邮箱]
- 🐛 Issues: [项目Issues链接]

---

**最后更新**: 2025-09-28