package com.tomwheeler.example.basicwizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class ExampleWizardPanel3 implements WizardDescriptor.Panel, ActionListener {

    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private ExampleVisualPanel3 component;
    private WizardDescriptor wizardDescriptor;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private boolean isValid;

    // Get the visual component for the panel. In this template, the component
    // is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to
    // create only those which really need to be visible.
    public Component getComponent() {
        if (component == null) {
            component = new ExampleVisualPanel3();
            component.getCheckBox().addActionListener(this);
        }
        return component;
    }

    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
        // If you have context help:
        // return new HelpCtx(SampleWizardPanel1.class);
    }
    public boolean isValid() {
        return isValid;
    }

    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }
    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void actionPerformed(ActionEvent e) {
        change();
    }

    private void change() {
        boolean isSelected = component.getCheckBox().isSelected();
        if (isSelected) {
            setValid(true);
        } else {
            setValid(false);
        }
    }

    private void setValid(boolean val) {
        if (isValid != val) {
            isValid = val;
            fireChangeEvent();  // must do this to enable next/finish button
        }
    }

    public void readSettings(Object settings) {
        // this field is initialized by the action that started the wizard
        wizardDescriptor = (WizardDescriptor) settings;

        Boolean checked = (Boolean)wizardDescriptor.getProperty(MyWizardSettingsValues.PROP_CHECKED);
        if (checked == null) {
            // first time around; default to false
            component.getCheckBox().setSelected(false);
        } else {
            component.getCheckBox().setSelected(checked.booleanValue());
        }
    }

    public void storeSettings(Object settings) {
        wizardDescriptor = (WizardDescriptor) settings;

        boolean checked = component.getCheckBox().isSelected();
        wizardDescriptor.putProperty(MyWizardSettingsValues.PROP_CHECKED, Boolean.valueOf(checked));
    }
}

