/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf.util;

import com.orsonpdf.util.Args;
import java.awt.GradientPaint;

public final class GradientPaintKey {
    private GradientPaint paint;

    public GradientPaintKey(GradientPaint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.paint = paint;
    }

    public GradientPaint getPaint() {
        return this.paint;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GradientPaintKey)) {
            return false;
        }
        GradientPaintKey that = (GradientPaintKey)obj;
        GradientPaint thisGP = this.paint;
        GradientPaint thatGP = that.getPaint();
        if (!thisGP.getColor1().equals(thatGP.getColor1())) {
            return false;
        }
        if (!thisGP.getColor2().equals(thatGP.getColor2())) {
            return false;
        }
        if (!thisGP.getPoint1().equals(thatGP.getPoint1())) {
            return false;
        }
        if (!thisGP.getPoint2().equals(thatGP.getPoint2())) {
            return false;
        }
        if (thisGP.getTransparency() != thatGP.getTransparency()) {
            return false;
        }
        return thisGP.isCyclic() == thatGP.isCyclic();
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.paint.getPoint1().hashCode();
        hash = 47 * hash + this.paint.getPoint2().hashCode();
        hash = 47 * hash + this.paint.getColor1().hashCode();
        hash = 47 * hash + this.paint.getColor2().hashCode();
        return hash;
    }
}

