/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.Dictionary;
import com.orsonpdf.Stream;
import com.orsonpdf.util.Args;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class PDFImage
extends Stream {
    int width;
    int height;
    Image image;

    public PDFImage(int number, Image img) {
        super(number);
        Args.nullNotPermitted(img, "img");
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.image = img;
    }

    @Override
    public byte[] getRawStreamData() {
        BufferedImage bi;
        if (!(this.image instanceof BufferedImage)) {
            bi = new BufferedImage(this.width, this.height, 1);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(this.image, 0, 0, null);
        } else {
            bi = (BufferedImage)this.image;
        }
        byte[] result = new byte[this.width * this.height * 3];
        int i = 0;
        for (int hh = this.height - 1; hh >= 0; --hh) {
            for (int ww = 0; ww < this.width; ++ww) {
                int rgb = bi.getRGB(ww, hh);
                result[i++] = (byte)(rgb >> 16);
                result[i++] = (byte)(rgb >> 8);
                result[i++] = (byte)rgb;
            }
        }
        return result;
    }

    @Override
    protected Dictionary createDictionary(int streamLength) {
        Dictionary dictionary = super.createDictionary(streamLength);
        dictionary.setType("/XObject");
        dictionary.put("/Subtype", "/Image");
        dictionary.put("/ColorSpace", "/DeviceRGB");
        dictionary.put("/BitsPerComponent", 8);
        dictionary.put("/Width", this.width);
        dictionary.put("/Height", this.height);
        return dictionary;
    }
}

