/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.SlidingGanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RefineryUtilities;

public class SlidingGanttDatasetDemo1
extends ApplicationFrame {
    public SlidingGanttDatasetDemo1(String string) {
        super(string);
        this.setDefaultCloseOperation(3);
        this.setContentPane(SlidingGanttDatasetDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        SlidingGanttDatasetDemo1 slidingGanttDatasetDemo1 = new SlidingGanttDatasetDemo1("JFreeChart: SlidingGanttDatasetDemo1.java");
        slidingGanttDatasetDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)slidingGanttDatasetDemo1));
        slidingGanttDatasetDemo1.setVisible(true);
    }

    static class DemoPanel
    extends JPanel
    implements ChangeListener {
        JScrollBar scroller;
        SlidingGanttCategoryDataset dataset = new SlidingGanttCategoryDataset(DemoPanel.createDataset(), 0, 15);

        public DemoPanel() {
            super(new BorderLayout());
            JFreeChart jFreeChart = DemoPanel.createChart(this.dataset);
            ChartPanel chartPanel = new ChartPanel(jFreeChart);
            chartPanel.setPreferredSize(new Dimension(400, 400));
            this.scroller = new JScrollBar(1, 0, 15, 0, 50);
            this.add(chartPanel);
            this.scroller.getModel().addChangeListener(this);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.scroller);
            jPanel.setBorder(BorderFactory.createEmptyBorder(66, 2, 2, 2));
            this.add((Component)jPanel, "East");
        }

        public static GanttCategoryDataset createDataset() {
            TaskSeries taskSeries = new TaskSeries("Scheduled");
            Day day = new Day();
            Day day2 = new Day();
            for (int i = 0; i < 50; ++i) {
                int n = (int)(Math.random() * 10.0) + 1;
                for (int j = 0; j < n; ++j) {
                    day2 = (Day)day2.next();
                }
                taskSeries.add(new Task("Task " + i, new Date(day.getMiddleMillisecond()), new Date(day2.getMiddleMillisecond())));
                day = (Day)day2.next();
                day2 = (Day)day2.next();
            }
            TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
            taskSeriesCollection.add(taskSeries);
            return taskSeriesCollection;
        }

        private static JFreeChart createChart(SlidingGanttCategoryDataset slidingGanttCategoryDataset) {
            Cloneable cloneable;
            JFreeChart jFreeChart = ChartFactory.createGanttChart("Gantt Chart Demo", "Task", "Date", slidingGanttCategoryDataset, true, true, false);
            CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            Hour hour = new Hour(1, 14, 5, 2008);
            for (int i = 0; i < 12; ++i) {
                cloneable = new IntervalMarker(hour.getFirstMillisecond(), hour.getLastMillisecond(), Color.lightGray);
                categoryPlot.addRangeMarker((Marker)cloneable, Layer.BACKGROUND);
                hour = (Hour)hour.next().next();
            }
            categoryPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(10.0f);
            DateAxis dateAxis = (DateAxis)categoryPlot.getRangeAxis();
            dateAxis.setRange(DatasetUtilities.findRangeBounds(slidingGanttCategoryDataset.getUnderlyingDataset(), true));
            cloneable = (GanttRenderer)categoryPlot.getRenderer();
            ((BarRenderer)cloneable).setDrawBarOutline(false);
            ((BarRenderer)cloneable).setShadowVisible(false);
            return jFreeChart;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.dataset.setFirstCategoryIndex(this.scroller.getValue());
        }
    }
}

