/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.editor;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.experimental.chart.swt.editor.SWTAxisEditor;

class SWTNumberAxisEditor
extends SWTAxisEditor
implements FocusListener {
    private boolean autoRange;
    private double minimumValue;
    private double maximumValue;
    private Button autoRangeCheckBox;
    private Text minimumRangeValue;
    private Text maximumRangeValue;

    public SWTNumberAxisEditor(Composite parent, int style, NumberAxis axis) {
        super(parent, style, (Axis)axis);
        this.autoRange = axis.isAutoRange();
        this.minimumValue = axis.getLowerBound();
        this.maximumValue = axis.getUpperBound();
        TabItem item2 = new TabItem(this.getOtherTabs(), 0);
        item2.setText(" " + localizationResources.getString("Range") + " ");
        Composite range = new Composite((Composite)this.getOtherTabs(), 0);
        range.setLayout((Layout)new GridLayout(2, true));
        item2.setControl((Control)range);
        this.autoRangeCheckBox = new Button(range, 32);
        this.autoRangeCheckBox.setText(localizationResources.getString("Auto-adjust_range"));
        this.autoRangeCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.autoRangeCheckBox.setSelection(this.autoRange);
        this.autoRangeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTNumberAxisEditor.this.toggleAutoRange();
            }
        });
        new Label(range, 0).setText(localizationResources.getString("Minimum_range_value"));
        this.minimumRangeValue = new Text(range, 2048);
        this.minimumRangeValue.setText(String.valueOf(this.minimumValue));
        this.minimumRangeValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumRangeValue.setEnabled(!this.autoRange);
        this.minimumRangeValue.addFocusListener((FocusListener)this);
        new Label(range, 0).setText(localizationResources.getString("Maximum_range_value"));
        this.maximumRangeValue = new Text(range, 2048);
        this.maximumRangeValue.setText(String.valueOf(this.maximumValue));
        this.maximumRangeValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maximumRangeValue.setEnabled(!this.autoRange);
        this.maximumRangeValue.addFocusListener((FocusListener)this);
    }

    public void toggleAutoRange() {
        this.autoRange = this.autoRangeCheckBox.getSelection();
        if (this.autoRange) {
            this.minimumRangeValue.setText(Double.toString(this.minimumValue));
            this.minimumRangeValue.setEnabled(false);
            this.maximumRangeValue.setText(Double.toString(this.maximumValue));
            this.maximumRangeValue.setEnabled(false);
        } else {
            this.minimumRangeValue.setEnabled(true);
            this.maximumRangeValue.setEnabled(true);
        }
    }

    public boolean validateMinimum(String candidate) {
        boolean valid = true;
        try {
            if (Double.parseDouble(candidate) >= this.maximumValue) {
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public boolean validateMaximum(String candidate) {
        boolean valid = true;
        try {
            if (Double.parseDouble(candidate) <= this.minimumValue) {
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.minimumRangeValue) {
            if (!this.validateMinimum(this.minimumRangeValue.getText())) {
                this.minimumRangeValue.setText(String.valueOf(this.minimumValue));
            } else {
                this.minimumValue = Double.parseDouble(this.minimumRangeValue.getText());
            }
        } else if (e.getSource() == this.maximumRangeValue) {
            if (!this.validateMaximum(this.maximumRangeValue.getText())) {
                this.maximumRangeValue.setText(String.valueOf(this.maximumValue));
            } else {
                this.maximumValue = Double.parseDouble(this.maximumRangeValue.getText());
            }
        }
    }

    @Override
    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setAutoRange(this.autoRange);
        if (!this.autoRange) {
            numberAxis.setRange(this.minimumValue, this.maximumValue);
        }
    }
}

