/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Range;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.Values3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.ItemLabelPositioning;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.AbstractCategoryRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;

public class BarRenderer3D
extends AbstractCategoryRenderer3D
implements Serializable {
    private double base = 0.0;
    private double barXWidth = 0.8;
    private double barZWidth = 0.5;
    private CategoryColorSource baseColorSource = new StandardCategoryColorSource(Color.WHITE);
    private CategoryColorSource topColorSource = new StandardCategoryColorSource(Color.BLACK);

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.fireChangeEvent(true);
    }

    public double getBarXWidth() {
        return this.barXWidth;
    }

    public void setBarXWidth(double barXWidth) {
        this.barXWidth = barXWidth;
        this.fireChangeEvent(true);
    }

    public double getBarZWidth() {
        return this.barZWidth;
    }

    public void setBarZWidth(double barZWidth) {
        this.barZWidth = barZWidth;
        this.fireChangeEvent(true);
    }

    public CategoryColorSource getBaseColorSource() {
        return this.baseColorSource;
    }

    public void setBaseColorSource(CategoryColorSource source) {
        this.baseColorSource = source;
        this.fireChangeEvent(true);
    }

    public CategoryColorSource getTopColorSource() {
        return this.topColorSource;
    }

    public void setTopColorSource(CategoryColorSource source) {
        this.topColorSource = source;
        this.fireChangeEvent(true);
    }

    @Override
    public Range findValueRange(Values3D<? extends Number> data) {
        return DataUtils.findValueRange(data, this.base);
    }

    @Override
    public void composeItem(CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        double value = dataset.getDoubleValue(series, row, column);
        if (Double.isNaN(value)) {
            return;
        }
        this.composeItem(value, this.base, dataset, series, row, column, world, dimensions, xOffset, yOffset, zOffset);
    }

    protected void composeItem(double value, double barBase, CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        Comparable<?> seriesKey = dataset.getSeriesKey(series);
        Comparable<?> rowKey = dataset.getRowKey(row);
        Comparable<?> columnKey = dataset.getColumnKey(column);
        double vlow = Math.min(barBase, value);
        double vhigh = Math.max(barBase, value);
        CategoryPlot3D plot = this.getPlot();
        CategoryAxis3D rowAxis = plot.getRowAxis();
        CategoryAxis3D columnAxis = plot.getColumnAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        Range range = valueAxis.getRange();
        if (!range.intersects(vlow, vhigh)) {
            return;
        }
        double vbase = range.peggedValue(vlow);
        double vtop = range.peggedValue(vhigh);
        boolean inverted = barBase > value;
        double rowValue = rowAxis.getCategoryValue(rowKey);
        double columnValue = columnAxis.getCategoryValue(columnKey);
        double width = dimensions.getWidth();
        double height = dimensions.getHeight();
        double depth = dimensions.getDepth();
        double xx = columnAxis.translateToWorld(columnValue, width) + xOffset;
        double yy = valueAxis.translateToWorld(vtop, height) + yOffset;
        double zz = rowAxis.translateToWorld(rowValue, depth) + zOffset;
        double xw = this.barXWidth * columnAxis.getCategoryWidth();
        double zw = this.barZWidth * rowAxis.getCategoryWidth();
        double xxw = columnAxis.translateToWorld(xw, width);
        double xzw = rowAxis.translateToWorld(zw, depth);
        double basew = valueAxis.translateToWorld(vbase, height) + yOffset;
        Color color = this.getColorSource().getColor(series, row, column);
        Color baseColor = null;
        if (this.baseColorSource != null && !range.contains(this.base)) {
            baseColor = this.baseColorSource.getColor(series, row, column);
        }
        if (baseColor == null) {
            baseColor = color;
        }
        Color topColor = null;
        if (this.topColorSource != null && !range.contains(value)) {
            topColor = this.topColorSource.getColor(series, row, column);
        }
        if (topColor == null) {
            topColor = color;
        }
        Object3D bar = Object3D.createBar(xxw, xzw, xx, yy, zz, basew, color, baseColor, topColor, inverted);
        KeyedValues3DItemKey itemKey = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
        bar.setProperty("key", itemKey);
        world.add(bar);
        this.drawItemLabels(world, dataset, itemKey, xx, yy, zz, basew, inverted);
    }

    protected void drawItemLabels(World world, CategoryDataset3D dataset, KeyedValues3DItemKey itemKey, double xw, double yw, double zw, double basew, boolean inverted) {
        ItemLabelPositioning positioning = this.getItemLabelPositioning();
        if (this.getItemLabelGenerator() == null) {
            return;
        }
        String label = this.getItemLabelGenerator().generateItemLabel(dataset, (Comparable<?>)itemKey.getSeriesKey(), (Comparable<?>)itemKey.getRowKey(), (Comparable<?>)itemKey.getColumnKey());
        if (label != null) {
            Dimension3D dimensions = this.getPlot().getDimensions();
            double dx = this.getItemLabelOffsets().getDX();
            double dy = this.getItemLabelOffsets().getDY() * dimensions.getHeight();
            double dz = this.getItemLabelOffsets().getDZ() * this.getBarZWidth();
            double yy = yw;
            if (inverted) {
                yy = basew;
                dy = -dy;
            }
            if (positioning.equals((Object)ItemLabelPositioning.CENTRAL)) {
                Object3D labelObj = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw + dx, yy + dy, zw, false, true);
                labelObj.setProperty("key", itemKey);
                world.add(labelObj);
            } else if (positioning.equals((Object)ItemLabelPositioning.FRONT_AND_BACK)) {
                Object3D labelObj1 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw + dx, yy + dy, zw + dz, false, false);
                labelObj1.setProperty("key", itemKey);
                world.add(labelObj1);
                Object3D labelObj2 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw + dx, yy + dy, zw - dz, true, false);
                labelObj1.setProperty("key", itemKey);
                world.add(labelObj2);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BarRenderer3D)) {
            return false;
        }
        BarRenderer3D that = (BarRenderer3D)obj;
        if (this.base != that.base) {
            return false;
        }
        if (this.barXWidth != that.barXWidth) {
            return false;
        }
        if (this.barZWidth != that.barZWidth) {
            return false;
        }
        if (!ObjectUtils.equals(this.baseColorSource, that.baseColorSource)) {
            return false;
        }
        if (!ObjectUtils.equals(this.topColorSource, that.topColorSource)) {
            return false;
        }
        return super.equals(obj);
    }
}

