/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.plot;

import com.orsoncharts.ChartElementVisitor;
import com.orsoncharts.axis.Axis3DChangeEvent;
import com.orsoncharts.axis.Axis3DChangeListener;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.Dataset3DChangeEvent;
import com.orsoncharts.data.Dataset3DChangeListener;
import com.orsoncharts.data.ItemKey;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZItemKey;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.StandardXYZItemLabelGenerator;
import com.orsoncharts.label.StandardXYZLabelGenerator;
import com.orsoncharts.label.XYZItemLabelGenerator;
import com.orsoncharts.label.XYZLabelGenerator;
import com.orsoncharts.legend.LegendItemInfo;
import com.orsoncharts.legend.StandardLegendItemInfo;
import com.orsoncharts.plot.AbstractPlot3D;
import com.orsoncharts.renderer.ComposeType;
import com.orsoncharts.renderer.Renderer3DChangeEvent;
import com.orsoncharts.renderer.Renderer3DChangeListener;
import com.orsoncharts.renderer.xyz.XYZRenderer;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.SerialUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYZPlot
extends AbstractPlot3D
implements Dataset3DChangeListener,
Axis3DChangeListener,
Renderer3DChangeListener,
Serializable {
    private static Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private XYZDataset dataset;
    private XYZRenderer renderer;
    private ValueAxis3D xAxis;
    private ValueAxis3D yAxis;
    private ValueAxis3D zAxis;
    private boolean gridlinesVisibleX;
    private transient Paint gridlinePaintX;
    private transient Stroke gridlineStrokeX;
    private boolean gridlinesVisibleY;
    private transient Paint gridlinePaintY;
    private transient Stroke gridlineStrokeY;
    private boolean gridlinesVisibleZ;
    private transient Paint gridlinePaintZ;
    private transient Stroke gridlineStrokeZ;
    private XYZLabelGenerator legendLabelGenerator;
    private XYZItemLabelGenerator toolTipGenerator;

    public XYZPlot(XYZDataset dataset, XYZRenderer renderer, ValueAxis3D xAxis, ValueAxis3D yAxis, ValueAxis3D zAxis) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArgChecks.nullNotPermitted(renderer, "renderer");
        ArgChecks.nullNotPermitted(xAxis, "xAxis");
        ArgChecks.nullNotPermitted(yAxis, "yAxis");
        ArgChecks.nullNotPermitted(zAxis, "zAxis");
        this.dimensions = new Dimension3D(10.0, 10.0, 10.0);
        this.dataset = dataset;
        this.dataset.addChangeListener(this);
        this.renderer = renderer;
        this.renderer.setPlot(this);
        this.renderer.addChangeListener(this);
        this.xAxis = xAxis;
        this.xAxis.addChangeListener(this);
        this.xAxis.configureAsXAxis(this);
        this.zAxis = zAxis;
        this.zAxis.addChangeListener(this);
        this.zAxis.configureAsZAxis(this);
        this.yAxis = yAxis;
        this.yAxis.addChangeListener(this);
        this.yAxis.configureAsYAxis(this);
        this.gridlinesVisibleX = true;
        this.gridlinePaintX = Color.WHITE;
        this.gridlineStrokeX = DEFAULT_GRIDLINE_STROKE;
        this.gridlinesVisibleY = true;
        this.gridlinePaintY = Color.WHITE;
        this.gridlineStrokeY = DEFAULT_GRIDLINE_STROKE;
        this.gridlinesVisibleZ = true;
        this.gridlinePaintZ = Color.WHITE;
        this.gridlineStrokeZ = DEFAULT_GRIDLINE_STROKE;
        this.legendLabelGenerator = new StandardXYZLabelGenerator();
        this.toolTipGenerator = new StandardXYZItemLabelGenerator();
    }

    public void setDimensions(Dimension3D dim) {
        ArgChecks.nullNotPermitted(dim, "dim");
        this.dimensions = dim;
        this.fireChangeEvent(true);
    }

    public XYZDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYZDataset dataset) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        this.dataset.removeChangeListener(this);
        this.dataset = dataset;
        this.dataset.addChangeListener(this);
        this.fireChangeEvent(true);
    }

    public ValueAxis3D getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(ValueAxis3D xAxis) {
        ArgChecks.nullNotPermitted(xAxis, "xAxis");
        this.xAxis.removeChangeListener(this);
        xAxis.configureAsXAxis(this);
        xAxis.addChangeListener(this);
        this.xAxis = xAxis;
        this.fireChangeEvent(true);
    }

    public ValueAxis3D getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(ValueAxis3D yAxis) {
        ArgChecks.nullNotPermitted(yAxis, "yAxis");
        this.yAxis.removeChangeListener(this);
        yAxis.configureAsYAxis(this);
        yAxis.addChangeListener(this);
        this.yAxis = yAxis;
        this.fireChangeEvent(true);
    }

    public ValueAxis3D getZAxis() {
        return this.zAxis;
    }

    public void setZAxis(ValueAxis3D zAxis) {
        ArgChecks.nullNotPermitted(zAxis, "zAxis");
        this.zAxis.removeChangeListener(this);
        zAxis.configureAsZAxis(this);
        zAxis.addChangeListener(this);
        this.zAxis = zAxis;
        this.fireChangeEvent(true);
    }

    public XYZRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(XYZRenderer renderer) {
        this.renderer.setPlot(null);
        this.renderer.removeChangeListener(this);
        this.renderer = renderer;
        this.renderer.setPlot(this);
        this.renderer.addChangeListener(this);
        this.fireChangeEvent(true);
    }

    public boolean isGridlinesVisibleX() {
        return this.gridlinesVisibleX;
    }

    public void setGridlinesVisibleX(boolean visible) {
        this.gridlinesVisibleX = visible;
        this.fireChangeEvent(false);
    }

    public Paint getGridlinePaintX() {
        return this.gridlinePaintX;
    }

    public void setGridlinePaintX(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.gridlinePaintX = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getGridlineStrokeX() {
        return this.gridlineStrokeX;
    }

    public void setGridlineStrokeX(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.gridlineStrokeX = stroke;
        this.fireChangeEvent(false);
    }

    public boolean isGridlinesVisibleY() {
        return this.gridlinesVisibleY;
    }

    public void setGridlinesVisibleY(boolean visible) {
        this.gridlinesVisibleY = visible;
        this.fireChangeEvent(false);
    }

    public Paint getGridlinePaintY() {
        return this.gridlinePaintY;
    }

    public void setGridlinePaintY(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.gridlinePaintY = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getGridlineStrokeY() {
        return this.gridlineStrokeY;
    }

    public void setGridlineStrokeY(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.gridlineStrokeY = stroke;
        this.fireChangeEvent(false);
    }

    public boolean isGridlinesVisibleZ() {
        return this.gridlinesVisibleZ;
    }

    public void setGridlinesVisibleZ(boolean visible) {
        this.gridlinesVisibleZ = visible;
        this.fireChangeEvent(false);
    }

    public Paint getGridlinePaintZ() {
        return this.gridlinePaintZ;
    }

    public void setGridlinePaintZ(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.gridlinePaintZ = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getGridlineStrokeZ() {
        return this.gridlineStrokeZ;
    }

    public void setGridlineStrokeZ(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.gridlineStrokeZ = stroke;
        this.fireChangeEvent(false);
    }

    public XYZLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(XYZLabelGenerator generator) {
        ArgChecks.nullNotPermitted(generator, "generator");
        this.legendLabelGenerator = generator;
        this.fireChangeEvent(false);
    }

    @Override
    public List<LegendItemInfo> getLegendInfo() {
        ArrayList<LegendItemInfo> result = new ArrayList<LegendItemInfo>();
        List<Comparable<?>> keys = this.dataset.getSeriesKeys();
        for (Comparable<?> key : keys) {
            String label = this.legendLabelGenerator.generateSeriesLabel(this.dataset, key);
            int series = this.dataset.getSeriesIndex(key);
            Color color = this.renderer.getColorSource().getLegendColor(series);
            StandardLegendItemInfo info = new StandardLegendItemInfo(key, label, color);
            result.add(info);
        }
        return result;
    }

    @Override
    public void compose(World world, double xOffset, double yOffset, double zOffset) {
        if (this.renderer.getComposeType() == ComposeType.ALL) {
            this.renderer.composeAll(this, world, this.dimensions, xOffset, yOffset, zOffset);
        } else if (this.renderer.getComposeType() == ComposeType.PER_ITEM) {
            int seriesCount = this.dataset.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = this.dataset.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    this.renderer.composeItem(this.dataset, series, item, world, this.dimensions, xOffset, yOffset, zOffset);
                }
            }
        } else {
            throw new IllegalStateException("ComposeType not expected: " + (Object)((Object)this.renderer.getComposeType()));
        }
    }

    @Override
    public String generateToolTipText(ItemKey itemKey) {
        if (!(itemKey instanceof XYZItemKey)) {
            throw new IllegalArgumentException("The itemKey must be a XYZItemKey instance.");
        }
        if (this.toolTipGenerator == null) {
            return null;
        }
        XYZItemKey k = (XYZItemKey)itemKey;
        return this.toolTipGenerator.generateItemLabel(this.dataset, (Comparable<?>)k.getSeriesKey(), k.getItemIndex());
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        this.xAxis.receive(visitor);
        this.yAxis.receive(visitor);
        this.zAxis.receive(visitor);
        this.renderer.receive(visitor);
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZPlot)) {
            return false;
        }
        XYZPlot that = (XYZPlot)obj;
        if (!this.dimensions.equals(that.dimensions)) {
            return false;
        }
        if (this.gridlinesVisibleX != that.gridlinesVisibleX) {
            return false;
        }
        if (this.gridlinesVisibleY != that.gridlinesVisibleY) {
            return false;
        }
        if (this.gridlinesVisibleZ != that.gridlinesVisibleZ) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.gridlinePaintX, that.gridlinePaintX)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.gridlinePaintY, that.gridlinePaintY)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.gridlinePaintZ, that.gridlinePaintZ)) {
            return false;
        }
        if (!this.gridlineStrokeX.equals(that.gridlineStrokeX)) {
            return false;
        }
        if (!this.gridlineStrokeY.equals(that.gridlineStrokeY)) {
            return false;
        }
        if (!this.gridlineStrokeZ.equals(that.gridlineStrokeZ)) {
            return false;
        }
        if (!this.legendLabelGenerator.equals(that.legendLabelGenerator)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void axisChanged(Axis3DChangeEvent event) {
        this.yAxis.configureAsYAxis(this);
        this.fireChangeEvent(event.requiresWorldUpdate());
    }

    @Override
    public void rendererChanged(Renderer3DChangeEvent event) {
        this.fireChangeEvent(event.requiresWorldUpdate());
    }

    @Override
    public void datasetChanged(Dataset3DChangeEvent event) {
        this.xAxis.configureAsXAxis(this);
        this.yAxis.configureAsYAxis(this);
        this.zAxis.configureAsZAxis(this);
        super.datasetChanged(event);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.gridlinePaintX, stream);
        SerialUtils.writePaint(this.gridlinePaintY, stream);
        SerialUtils.writePaint(this.gridlinePaintZ, stream);
        SerialUtils.writeStroke(this.gridlineStrokeX, stream);
        SerialUtils.writeStroke(this.gridlineStrokeY, stream);
        SerialUtils.writeStroke(this.gridlineStrokeZ, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.gridlinePaintX = SerialUtils.readPaint(stream);
        this.gridlinePaintY = SerialUtils.readPaint(stream);
        this.gridlinePaintZ = SerialUtils.readPaint(stream);
        this.gridlineStrokeX = SerialUtils.readStroke(stream);
        this.gridlineStrokeY = SerialUtils.readStroke(stream);
        this.gridlineStrokeZ = SerialUtils.readStroke(stream);
    }
}

