/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.label;

import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.label.XYZLabelGenerator;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.Formatter;

public class StandardXYZLabelGenerator
implements XYZLabelGenerator,
Serializable {
    public static final String KEY_ONLY_TEMPLATE = "%s";
    public static final String TOTAL_TEMPLATE = "%s (%3$,.0f)";
    public static final String TOTAL_TEMPLATE_2DP = "%s (%3$,.2f)";
    public static final String COUNT_TEMPLATE = "%s (%2$,d)";
    public static final String DEFAULT_TEMPLATE = "%s";
    private String template;

    public StandardXYZLabelGenerator() {
        this("%s");
    }

    public StandardXYZLabelGenerator(String template) {
        ArgChecks.nullNotPermitted(template, "template");
        this.template = template;
    }

    @Override
    public String generateSeriesLabel(XYZDataset dataset, Comparable<?> seriesKey) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        Formatter formatter = new Formatter(new StringBuilder());
        int count = dataset.getItemCount(dataset.getSeriesIndex(seriesKey));
        double total = DataUtils.total(dataset, seriesKey);
        formatter.format(this.template, seriesKey, count, total);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYZLabelGenerator)) {
            return false;
        }
        StandardXYZLabelGenerator that = (StandardXYZLabelGenerator)obj;
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }
}

