/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.data.xyz.XYZDataItem;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYZSeries
implements Serializable {
    private final Comparable<?> key;
    private final List<XYZDataItem> items;

    public XYZSeries(Comparable<?> key) {
        ArgChecks.nullNotPermitted(key, "key");
        this.key = key;
        this.items = new ArrayList<XYZDataItem>();
    }

    public Comparable<?> getKey() {
        return this.key;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public double getXValue(int itemIndex) {
        return this.items.get(itemIndex).getX();
    }

    public double getYValue(int itemIndex) {
        return this.items.get(itemIndex).getY();
    }

    public double getZValue(int itemIndex) {
        return this.items.get(itemIndex).getZ();
    }

    public void add(double x, double y, double z) {
        this.add(new XYZDataItem(x, y, z));
    }

    public void add(XYZDataItem item) {
        ArgChecks.nullNotPermitted(item, "item");
        this.items.add(item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZSeries)) {
            return false;
        }
        XYZSeries that = (XYZSeries)obj;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.items.equals(that.items);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + ObjectUtils.hashCode(this.key);
        return hash;
    }
}

