/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.data.ItemKey;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;

public class XYZItemKey<S extends Comparable<S>>
implements ItemKey,
Comparable<XYZItemKey<S>>,
Serializable {
    private final S seriesKey;
    private final int itemIndex;

    public XYZItemKey(S seriesKey, int itemIndex) {
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        this.seriesKey = seriesKey;
        this.itemIndex = itemIndex;
    }

    public S getSeriesKey() {
        return this.seriesKey;
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZItemKey)) {
            return false;
        }
        XYZItemKey that = (XYZItemKey)obj;
        if (!this.seriesKey.equals(that.seriesKey)) {
            return false;
        }
        return this.itemIndex == that.itemIndex;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + ObjectUtils.hashCode(this.seriesKey);
        hash = 41 * hash + this.itemIndex;
        return hash;
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"seriesKey\": \"").append(this.seriesKey.toString());
        sb.append("\", ");
        sb.append("\"itemIndex\": ").append(this.itemIndex).append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYZItemKey[seriesKey=");
        sb.append(this.seriesKey.toString()).append(",item=");
        sb.append(this.itemIndex);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(XYZItemKey<S> key) {
        int result = this.seriesKey.compareTo(key.seriesKey);
        if (result == 0) {
            result = this.itemIndex - key.itemIndex;
        }
        return result;
    }
}

